#include <stdio.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <stdlib.h>

#include <unistd.h>

#include "socket.h"

int main(int argc, char **argv) {
    struct sockaddr addr;
    int port = 3434;
    int vrf = 0;
    int one = 1;
    int type = SOCK_STREAM;
    int opt;
    int fd;


    while((opt = getopt(argc,argv,"p:n:d")) > 0) {
	switch(opt) {
	    case 'p':
		port = atoi(optarg);
		break;
	    case 'd':
		type = SOCK_DGRAM;
		break;
	    case 'n':
		vrf = atoi(optarg);
		break;
	    default:
		exit(-1);
	}
    }

    if ((fd = socket(AF_INET,type,0)) < 0) {
	perror("socket");
	exit(-1);
    }

    if (vrf) {
    if(setsockopt(fd,SOL_SOCKET,SO_NSID,(char *)&vrf,sizeof(vrf)) < 0) {
	perror("setsocketopt1");
	exit(-1);
    }
    }

    addr.sa_family = AF_INET;
    ((struct sockaddr_in *)&addr)->sin_port = htons(port);
    ((struct sockaddr_in *)&addr)->sin_addr.s_addr = INADDR_ANY;
    if(bind(fd, &addr, sizeof(struct sockaddr_in)) < 0) {
	perror("bind");
	exit(-1);
    }

    if(type == SOCK_STREAM && listen(fd,5) < 0) {
	perror("listen");
	exit(-1);
    }
    if(setsockopt(fd,SOL_SOCKET,SO_REUSEADDR,(char *)&one,sizeof(one)) < 0) {
	perror("setsocketopt2");
	exit(-1);
    }

    while(1) {
	printf("Going to sleep\n");
	sleep(100);
    }
    return 0;
}
