/* (C) 2002 Yon Uriarte <havanna_moon@gmx.net>
 * ripped from port.c by J.Leu
 * Licensed under the GPL
 * Modified for network namespaces by V.Chappelier
 */

#include <stdio.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>

#include "socket.h"

int main(int argc, char **argv, char **envp) {
  int vrf = 0;
  int fd;

  if(argc < 3 ) {
    printf("Usage: %s nsid command <commandopts>\n", argv[0]);
    exit(1);
  }
  vrf = atoi(argv[1]);

  if ((fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
    perror("socket");
    exit(-1);
  }

  if (vrf)
    if(setsockopt(fd, SOL_SOCKET, SO_NETNS, (int *)&vrf, sizeof(vrf)) < 0) {
      perror("setsocketopt");
      exit(-1);
    }
  
  execvp(argv[2],&argv[2]);
  if( errno == EACCES )
    printf("Program %s not found.\n", argv[2]);
  else if( errno == ENOEXEC )
    printf("Program %s not executable.\n", argv[2]);

  exit(-2);
}
