#include "fstress.h"

void populate(double **wspace, int nelem, int nthreads)
   /* nelem -- elements per thread  */
{
   const int STATE_SIZE = 32 ;  /* 32 bytes per stream */
   unsigned int seed = 11 ; /* fixed for deterministic results */
   char rand_statebuf[STATE_SIZE] ;
   struct random_data rand_buf ;
   int32_t randres ;
   int thrd, elem ;

   memset(rand_statebuf, 0, STATE_SIZE) ;
   memset(&rand_buf, 0, sizeof(struct random_data)) ;

   if  ((initstate_r(seed, rand_statebuf, STATE_SIZE, &rand_buf)) != 0)
      ERRperror("initstate_r")

   for  (thrd = 0 ; thrd < nthreads ; thrd++)  {
      for  (elem = 0 ; elem < nelem ; elem++)  {
	 /*
	 if  (random_r(&rand_buf, &randres) != 0)
	    ERRperror("random_r") ;
	 wspace[thrd][elem] = (double)randres/(double)(RAND_MAX) +
	                      (double)elem/(double)nelem ;
	 */
	 wspace[thrd][elem] = 1.0 ;
      }
   }
}

unsigned int mod(int a, int b)
{
   return((a % b + b) % b) ;
}
