/* Stress floating point operations across a specieid amount of memo */

#include "fstress.h"

int main(int argc, char *argv[])
{
   void *doit() ;   /* thread */
   int memsize = 4  ;  /* tot mem size per thread in MB */
   int nthreads = 1 ;  /* number of threads */
   int *thread_ids ;
   pthread_t *threadbufs ;
   double thrdsum ;
   int thrd ;

   niter = 10 ;

   if  (argc == 2 && strcmp(argv[1],"-h") == 0)  {
      printf(
	 "fstress1 memsiz(MB)[%d] niterations[%d] nthreads[%d]\n",
	 memsize, niter, nthreads) ;
      exit(0) ;
   }

   if  (argc >= 2)  {
      memsize = atoi(argv[1]) ;
      if  (memsize < 1 || memsize > 10000)
	 ERR2("bad number of MB: %d", memsize)
   }
   if  (argc >= 3)  {
      niter = atoi(argv[2]) ;
      if  (niter < 1 || niter > 1000000000)
	 ERR2("bad number of iterations: %d", niter)
   }
   if  (argc >= 4)  {
      nthreads = atoi(argv[3]) ;
      if  (nthreads < 1 || nthreads > 100)
	 ERR2("bad number of threads: %d", nthreads)
   }

   nthreads = 1 ;

   printf("fstress %d %d %d\n\n", memsize, niter, nthreads) ;

   if  ((wspace = calloc(1,sizeof(double *) * nthreads))
        == NULL)
      ERRperror("calloc pointer to workspaces")
   nelem = memsize * 1000000 / sizeof(double) ;
   for  (thrd = 0 ; thrd < nthreads ; thrd++)  {
      if  ((wspace[thrd] = calloc(1,sizeof(double *) * nelem)) == NULL)
	 ERRperror("calloc workspaces")
   }
   if  ((thrdres = calloc(1,sizeof(double) * nthreads)) == NULL)
	 ERRperror("calloc thrdres")

   populate(wspace, nelem, nthreads) ;

   if  ((threadbufs = calloc(1,sizeof(pthread_t) * nthreads)) == NULL)
      ERRperror("calloc thread contexts")
   if  ((thread_ids = calloc(1,sizeof(int) * nthreads)) == NULL)
      ERRperror("calloc thread ids")

   for  (thrd = 0 ; thrd < nthreads ; thrd++)  {
      thread_ids[thrd] = thrd ;
      if  (pthread_create(&threadbufs[thrd], NULL, doit,
                          (void *) &thread_ids[thrd]) != 0)
	 ERRperror("pthread_create") ;
   }

   thrdsum = 0.0 ;
   for  (thrd = 0 ; thrd < nthreads ; thrd++)  {
      pthread_join(threadbufs[thrd],NULL) ;
      thrdsum = thrdsum + thrdres[thrd] ;
   }
   printf("total: %20.15f\n",thrdsum) ;
   for  (thrd = 0 ; thrd < nthreads ; thrd++)  {
      printf("%15.12f ", thrdres[thrd]) ;
   }
   printf("\n") ;
}
