#include "fstress.h"

void *doit(void *args)
{
   int thrd ;
   unsigned int iter ;
   unsigned int elem ;
   unsigned int low, high ;
   double a, b, c ;
   int errflag ;

   thrd = *(int *)args ;

   thrdres[thrd] = 0.0 ;
   for  (iter = 0 ; iter < niter ; iter++)  {
      for  (elem = 0 ; elem < nelem ; elem++)  {
	 errflag = 0 ;
	 low = mod(elem-iter, nelem) ;
	 high = mod(elem+iter, nelem) ;
	 a = wspace[thrd][elem] ;
	 b = wspace[thrd][low] ;
	 c = wspace[thrd][high] ;
	 if  (a != (double)1.0)  {
	    errflag = 1 ;
	    printf("iteration %d, reading element %4d = %15.12f\n",
	           iter, elem, a) ;
	 }
	 if  (b != (double)1.0)  {
	    errflag = 1 ;
	    printf("iteration %d, reading element %4d = %15.12f\n",
	           iter, low, b) ;
	 }
	 if  (c != (double)1.0)  {
	    errflag = 1 ;
	    printf("iteration %d, reading element %4d = %15.12f\n",
	           iter, high, c) ;
	 }
	 a = (a + b + c) / 3.0 ;
	 if  (a != (double)1.0)  {
	    errflag = 1 ;
	    printf("iteration %d, computed element %4d = %15.12f\n",
	           iter, elem, a) ;
	 }
	 wspace[thrd][elem] = (wspace[thrd][elem] + wspace[thrd][low] +
	                       wspace[thrd][high]) / 3.0 ;
	 a = wspace[thrd][elem] ;
	 if  (a != (double)1.0)  {
	    errflag = 1 ;
	    printf("iteration %d, RE-reading element %4d = %15.12f\n",
	           iter, elem, a) ;
	 }
	 b = wspace[thrd][low] ;
	 c = wspace[thrd][high] ;
	 if  (b != (double)1.0)  {
	    errflag = 1 ;
	    printf("iteration %d, RE-reading element %4d = %15.12f\n",
	           iter, low, b) ;
	 }
	 if  (c != (double)1.0)  {
	    errflag = 1 ;
	    printf("iteration %d, RE-reading element %4d = %15.12f\n",
	           iter, high, c) ;
	 }
	 if  (errflag)
	    return ;
      }
   }
   for  (elem = 0 ; elem < nelem ; elem++)
      thrdres[thrd] = thrdres[thrd] + wspace[thrd][elem] ;
   thrdres[thrd] = thrdres[thrd] / (double)nelem ;
}
